"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var assert_1 = __importDefault(require("./utils/assert"));
var objectToGetParams_1 = __importDefault(require("./utils/objectToGetParams"));
var createShareButton_1 = __importDefault(require("./hocs/createShareButton"));
function tumblrLink(url, _a) {
    var title = _a.title, caption = _a.caption, tags = _a.tags, posttype = _a.posttype;
    (0, assert_1.default)(url, 'tumblr.url');
    return ('https://www.tumblr.com/widgets/share/tool' +
        (0, objectToGetParams_1.default)({
            canonicalUrl: url,
            title: title,
            caption: caption,
            tags: tags,
            posttype: posttype,
        }));
}
var TumblrShareButton = (0, createShareButton_1.default)('tumblr', tumblrLink, function (props) { return ({
    title: props.title,
    tags: (props.tags || []).join(','),
    caption: props.caption,
    posttype: props.posttype || 'link',
}); }, {
    windowWidth: 660,
    windowHeight: 460,
});
exports.default = TumblrShareButton;
